# 📝 راهنمای گام‌به‌گام تنظیم Environment Variables در لیارا

## 🎯 مراحل دقیق

### مرحله 1: ورود به پنل لیارا

1. به آدرس زیر بروید:
   ```
   https://console.liara.ir
   ```

2. با حساب کاربری خود وارد شوید

### مرحله 2: پیدا کردن اپلیکیشن

1. در منوی سمت راست، روی **Apps** کلیک کنید
2. اپلیکیشن `viraving-web` را پیدا کنید
3. روی نام اپلیکیشن کلیک کنید

### مرحله 3: ورود به بخش Environment Variables

1. در صفحه اپلیکیشن، به منوی بالا نگاه کنید
2. روی تب **Environment Variables** کلیک کنید
   - یا در منوی سمت چپ، **Environment Variables** را پیدا کنید

### مرحله 4: اضافه کردن متغیرها

برای هر متغیر، این مراحل را انجام دهید:

1. روی دکمه **Add Variable** یا **+ Add** کلیک کنید
2. نام متغیر را در فیلد **Key** وارد کنید
3. مقدار را در فیلد **Value** وارد کنید
4. روی **Save** یا **Add** کلیک کنید

### مرحله 5: متغیرهای مورد نیاز

این متغیرها را یکی یکی اضافه کنید:

#### 1️⃣ Database Configuration

**Key:** `DB_HOST`  
**Value:** `my-vira`

---

**Key:** `DB_PORT`  
**Value:** `3306`

---

**Key:** `DB_USER`  
**Value:** `root`

---

**Key:** `DB_PASSWORD`  
**Value:** `7iyxrEhdo438xx9UZb4W37zC`

---

**Key:** `DB_NAME`  
**Value:** `kind_ardinghelli`

---

#### 2️⃣ JWT Secret

**Key:** `JWT_SECRET`  
**Value:** یک رشته تصادفی امن (حداقل 32 کاراکتر)

**تولید JWT_SECRET:**
```bash
node generate-jwt-secret.js
```

یا از این مقدار استفاده کنید:
```
eb443917628b54aa76a15b2a3eb422d3a0e8a8a007cd84a96a366b7a5aae7ccd
```

---

#### 3️⃣ Gemini AI API Key

**Key:** `GEMINI_API_KEY`  
**Value:** کلید API گوگل (از https://aistudio.google.com/app/apikey)

---

**Key:** `VITE_GEMINI_API_KEY`  
**Value:** همان کلید API گوگل (همان مقدار `GEMINI_API_KEY`)

---

#### 4️⃣ Server Configuration

**Key:** `PORT`  
**Value:** `3000`

---

**Key:** `NODE_ENV`  
**Value:** `production`

---

## ✅ چک‌لیست نهایی

بعد از اضافه کردن همه متغیرها، مطمئن شوید که:

- [ ] `DB_HOST` = `my-vira`
- [ ] `DB_PORT` = `3306`
- [ ] `DB_USER` = `root`
- [ ] `DB_PASSWORD` = `7iyxrEhdo438xx9UZb4W37zC`
- [ ] `DB_NAME` = `kind_ardinghelli`
- [ ] `JWT_SECRET` = (یک رشته امن)
- [ ] `GEMINI_API_KEY` = (کلید API)
- [ ] `VITE_GEMINI_API_KEY` = (همان کلید API)
- [ ] `PORT` = `3000`
- [ ] `NODE_ENV` = `production`

## 🔄 Restart سرور

پس از تنظیم همه متغیرها:

1. در صفحه اپلیکیشن، به بخش **Overview** بروید
2. روی دکمه **Restart** کلیک کنید
3. یا از منوی بالا، **Restart** را انتخاب کنید

## 📸 تصویر راهنما

```
پنل لیارا
├── Apps
│   └── viraving-web
│       ├── Overview
│       ├── Environment Variables  ← اینجا کلیک کنید
│       ├── Deploy
│       ├── Logs
│       └── Settings
```

## 🆘 اگر Environment Variables را پیدا نکردید

1. مطمئن شوید که در صفحه اپلیکیشن هستید (نه صفحه اصلی)
2. در منوی سمت چپ یا بالا، **Environment Variables** را جستجو کنید
3. ممکن است نام آن **Env Variables** یا **Variables** باشد

---

**موفق باشید! 🎉**

