# راهنمای نصب و راه‌اندازی در لیارا

## پیش‌نیازها

1. اکانت لیارا
2. یک دیتابیس MySQL در لیارا
3. Node.js 18 یا بالاتر

## مراحل نصب

### 1. ایجاد دیتابیس MySQL در لیارا

1. وارد پنل لیارا شوید
2. یک دیتابیس MySQL جدید ایجاد کنید
3. اطلاعات اتصال را یادداشت کنید:
   - Host
   - Port (معمولاً 3306)
   - Username
   - Password
   - Database Name

### 2. تنظیم متغیرهای محیطی در لیارا

در پنل لیارا، به بخش Environment Variables بروید و متغیرهای زیر را اضافه کنید:

```
DB_HOST=your-mysql-host.liara.cloud
DB_PORT=3306
DB_USER=root
DB_PASSWORD=your-password
DB_NAME=your-database-name
JWT_SECRET=your-super-secret-jwt-key-change-this
GEMINI_API_KEY=your-gemini-api-key
PORT=3001
```

### 3. آپلود پروژه به لیارا

```bash
# نصب Liara CLI (اگر نصب نشده)
npm install -g @liara/cli

# لاگین به لیارا
liara login

# آپلود پروژه
liara deploy
```

### 4. نصب اولیه

پس از آپلود، به آدرس سایت بروید. صفحه نصب‌کننده نمایش داده می‌شود:

1. **مرحله 1: اتصال به دیتابیس**
   - اطلاعات دیتابیس MySQL لیارا را وارد کنید
   - روی "مرحله بعد" کلیک کنید

2. **مرحله 2: ایجاد مدیر کل**
   - نام کاربری، ایمیل و رمز عبور مدیر را وارد کنید
   - روی "پایان نصب و ورود" کلیک کنید

### 5. دسترسی به پنل مدیریت

پس از نصب، به آدرس زیر بروید:
```
https://your-domain.com/#admin
```

## ساختار پروژه

```
viraving-web/
├── backend/          # سرور Node.js/Express
│   ├── db.js        # اتصال به MySQL
│   ├── routes.js    # API Routes
│   └── server.js    # سرور اصلی
├── src/             # Frontend React
│   ├── App.tsx
│   └── main.tsx
├── components/      # کامپوننت‌های React
├── services/        # سرویس‌های Frontend
└── liara.json       # تنظیمات لیارا
```

## نکات مهم

1. **امنیت**: حتماً `JWT_SECRET` را در production تغییر دهید
2. **دیتابیس**: جداول به صورت خودکار در اولین اتصال ایجاد می‌شوند
3. **فایل‌ها**: فایل‌های آپلود شده در `backend/public/uploads` ذخیره می‌شوند
4. **API**: تمام API ها در مسیر `/api` قرار دارند

## عیب‌یابی

### مشکل اتصال به دیتابیس
- بررسی کنید که متغیرهای محیطی به درستی تنظیم شده‌اند
- اطمینان حاصل کنید که IP سرور لیارا در whitelist دیتابیس MySQL قرار دارد

### مشکل در نصب
- لاگ‌های سرور را در پنل لیارا بررسی کنید
- اطمینان حاصل کنید که دیتابیس خالی است و جداول قبلی وجود ندارند

## پشتیبانی

برای مشکلات بیشتر، لاگ‌های سرور را در پنل لیارا بررسی کنید.

