# رفع مشکل Hover در کامپوننت Services

## مشکل
وقتی روی کارت‌های خدمات هاور می‌شود، باکس کمی به سمت بالا حرکت می‌کند و انگار کمی زیر می‌رود و مخفی می‌شود.

## علت
استفاده از `hover:-translate-y-2` که باعث می‌شود باکس 8px (0.5rem) به سمت بالا حرکت کند و از view خارج شود.

## راه حل

### تغییرات انجام شده:

1. **کاهش مقدار translate:**
   - قبل: `hover:-translate-y-2` (8px حرکت)
   - بعد: `hover:-translate-y-1` (4px حرکت)
   - حرکت کمتر = کمتر مخفی می‌شود

2. **اضافه کردن padding به container:**
   - قبل: `md:pb-0`
   - بعد: `md:pb-4 md:pt-2`
   - فضای اضافی برای حرکت باکس

## نتیجه

✅ باکس هنگام hover کمتر حرکت می‌کند (4px به جای 8px)
✅ فضای کافی برای حرکت باکس وجود دارد
✅ باکس دیگر مخفی نمی‌شود
✅ انیمیشن smooth و طبیعی است

## تغییرات

### `components/Services.tsx`

```tsx
// قبل:
className="... hover:-translate-y-2 ..."
<div className="... md:pb-0">

// بعد:
className="... hover:-translate-y-1 ..."
<div className="... md:pb-4 md:pt-2">
```

