# رفع مشکلات SQL و Rate Limiting

## مشکلات شناسایی شده

### 1. SQL Syntax Error
**مشکل:** 
```
Error: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near 'IF NOT EXISTS projectUrl TEXT' at line 1
```

**علت:** MySQL از `IF NOT EXISTS` در `ALTER TABLE ADD COLUMN` پشتیبانی نمی‌کند.

**راه حل:** ✅
- بررسی وجود ستون با `INFORMATION_SCHEMA.COLUMNS`
- اضافه کردن ستون فقط در صورت عدم وجود
- استفاده از try-catch برای مدیریت خطا

### 2. Rate Limiting Warning
**مشکل:**
```
ValidationError: The 'X-Forwarded-For' header is set but the Express 'trust proxy' setting is false
```

**علت:** Liara از reverse proxy استفاده می‌کند و نیاز به `trust proxy` دارد.

**راه حل:** ✅
- اضافه کردن `app.set('trust proxy', true)` در `server.js`

## تغییرات انجام شده

### `backend/db.js`
```javascript
// قبل:
ALTER TABLE projects 
ADD COLUMN IF NOT EXISTS projectUrl TEXT

// بعد:
// بررسی وجود ستون با INFORMATION_SCHEMA
const [columns] = await pool.execute(`
  SELECT COLUMN_NAME 
  FROM INFORMATION_SCHEMA.COLUMNS 
  WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'projects' 
  AND COLUMN_NAME = 'projectUrl'
`);

if (columns.length === 0) {
  await pool.execute(`
    ALTER TABLE projects 
    ADD COLUMN projectUrl TEXT
  `);
}
```

### `backend/server.js`
```javascript
// اضافه شده:
app.set('trust proxy', true);
```

## نتیجه

✅ مشکل SQL syntax برطرف شد
✅ مشکل rate limiting warning برطرف شد
✅ پروژه آماده deploy است

