# رفع مشکل Trust Proxy

## مشکل
```
ValidationError: The Express 'trust proxy' setting is true, which allows anyone to trivially bypass IP-based rate limiting.
```

## علت
`trust proxy: true` خیلی permissive است و به همه proxy ها اعتماد می‌کند که می‌تواند rate limiting را bypass کند.

## راه حل
تغییر `trust proxy` از `true` به `1`:
- `1` = فقط به اولین proxy اعتماد می‌کند (Liara reverse proxy)
- امن‌تر از `true` است
- هنوز IP واقعی کاربر را از `X-Forwarded-For` می‌خواند

## تغییرات

### `backend/server.js`
```javascript
// قبل:
app.set('trust proxy', true);

// بعد:
app.set('trust proxy', 1);
```

## نتیجه
✅ Rate limiting درست کار می‌کند
✅ امنیت بیشتر (فقط به اولین proxy اعتماد می‌کند)
✅ هشدار برطرف شد

