import React from 'react';
import { Home, Search, AlertTriangle } from 'lucide-react';

const NotFound: React.FC = () => {
  return (
    <div className="min-h-screen flex flex-col items-center justify-center p-4 text-center bg-slate-50 dark:bg-slate-900 transition-colors duration-300 animate-fade-in">
      
      {/* Decorative background number */}
      <h1 className="text-[150px] md:text-[200px] font-black text-slate-200 dark:text-slate-800/50 select-none leading-none">
        404
      </h1>
      
      <div className="relative -mt-16 mb-8 z-10">
        <div className="w-20 h-20 bg-indigo-100 dark:bg-indigo-900/30 text-indigo-600 dark:text-indigo-400 rounded-3xl flex items-center justify-center mx-auto mb-6 shadow-xl rotate-12">
            <AlertTriangle size={40} />
        </div>
        <h2 className="text-3xl md:text-4xl font-bold text-slate-900 dark:text-white mb-2">
          صفحه مورد نظر پیدا نشد!
        </h2>
        <p className="text-slate-600 dark:text-slate-400 max-w-md mx-auto text-lg">
          ممکن است آدرس را اشتباه وارد کرده باشید یا این صفحه حذف شده باشد.
        </p>
      </div>

      <div className="flex flex-col sm:flex-row gap-4 z-10">
        <a 
            href="#home" 
            onClick={(e) => { e.preventDefault(); window.location.hash = '#home'; }}
            className="flex items-center justify-center gap-2 bg-indigo-600 hover:bg-indigo-700 text-white px-8 py-3.5 rounded-xl transition-all shadow-lg shadow-indigo-600/20 font-bold"
        >
            <Home size={20} />
            بازگشت به صفحه اصلی
        </a>
      </div>
    </div>
  );
};

export default NotFound;