import React from 'react';

export const BlogSkeleton = () => (
  <div className="rounded-2xl overflow-hidden border border-slate-200 dark:border-slate-800 bg-white dark:bg-slate-900 shadow-sm flex flex-col h-full">
    <div className="aspect-video bg-slate-200 dark:bg-slate-800 animate-pulse"></div>
    <div className="p-6 flex-1 flex flex-col space-y-4">
      <div className="flex gap-2">
        <div className="h-5 w-20 bg-slate-200 dark:bg-slate-800 rounded animate-pulse"></div>
        <div className="h-5 w-16 bg-slate-200 dark:bg-slate-800 rounded animate-pulse"></div>
      </div>
      <div className="h-7 w-3/4 bg-slate-200 dark:bg-slate-800 rounded animate-pulse"></div>
      <div className="space-y-2 flex-1">
        <div className="h-3 w-full bg-slate-200 dark:bg-slate-800 rounded animate-pulse"></div>
        <div className="h-3 w-5/6 bg-slate-200 dark:bg-slate-800 rounded animate-pulse"></div>
        <div className="h-3 w-4/6 bg-slate-200 dark:bg-slate-800 rounded animate-pulse"></div>
      </div>
      <div className="pt-4 border-t border-slate-100 dark:border-slate-800 flex justify-between items-center mt-auto">
         <div className="h-4 w-24 bg-slate-200 dark:bg-slate-800 rounded animate-pulse"></div>
         <div className="h-4 w-20 bg-slate-200 dark:bg-slate-800 rounded animate-pulse"></div>
      </div>
    </div>
  </div>
);

export const ProjectSkeleton = () => (
  <div className="rounded-3xl overflow-hidden border border-slate-200 dark:border-slate-800 bg-white dark:bg-slate-900 h-full">
    <div className="aspect-[4/3] bg-slate-200 dark:bg-slate-800 animate-pulse"></div>
    <div className="p-6 space-y-3">
       <div className="h-4 w-24 bg-slate-200 dark:bg-slate-800 rounded animate-pulse"></div>
       <div className="h-6 w-3/4 bg-slate-200 dark:bg-slate-800 rounded animate-pulse"></div>
    </div>
  </div>
);